<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\UserController;

Route::group(['middleware' => 'apipurchasecode'], function () {

    // ---------------- UserController ----------------
    Route::post('registration', [UserController::class, 'registration']);
    Route::get('verify_email/{id}/{email}', [UserController::class, 'verify_email'])->name('verify_email')->middleware('signed');
    Route::post('forgot_password', [UserController::class, 'forgot_password']);
    Route::post('login', [UserController::class, 'login']);
    Route::post('get_profile', [UserController::class, 'get_profile']);
    Route::post('update_profile', [UserController::class, 'update_profile']);
    Route::post('get_badge_list', [UserController::class, 'get_badge_list']);
    Route::post('get_user_badge', [UserController::class, 'get_user_badge']);
    Route::post('get_avatar', [UserController::class, 'get_avatar']);
    Route::post('get_badge', [UserController::class, 'get_badge']);
    Route::post('coin_sharing', [UserController::class, 'coin_sharing']);

    // ---------------- HomeController ----------------
    Route::post('general_setting', [HomeController::class, 'general_setting']);
    Route::post('get_payment_option', [HomeController::class, 'get_payment_option']);
    Route::post('get_pages', [HomeController::class, 'get_pages']);
    Route::post('get_social_link', [HomeController::class, 'get_social_link']);
    Route::post('get_onboarding_screen', [HomeController::class, 'get_onboarding_screen']);
    Route::post('get_quiz_configuration', [HomeController::class, 'get_quiz_configuration']);
    Route::post('get_notification', [HomeController::class, 'get_notification']);
    Route::post('read_notification', [HomeController::class, 'read_notification']);
    Route::post('get_package', [HomeController::class, 'get_package']);
    Route::post('get_category', [HomeController::class, 'get_category']);
    Route::post('get_skill', [HomeController::class, 'get_skill']);
    Route::post('get_classification', [HomeController::class, 'get_classification']);
    Route::post('get_level', [HomeController::class, 'get_level']);
    Route::post('get_practice_question', [HomeController::class, 'get_practice_question']);
    Route::post('get_normal_question', [HomeController::class, 'get_normal_question']);
    Route::post('get_audio_question', [HomeController::class, 'get_audio_question']);
    Route::post('get_video_question', [HomeController::class, 'get_video_question']);
    Route::post('get_true_false_question', [HomeController::class, 'get_true_false_question']);
    Route::post('get_fear_factor_question', [HomeController::class, 'get_fear_factor_question']);
    Route::post('get_daily_quiz_question', [HomeController::class, 'get_daily_quiz_question']);
    Route::post('save_practice_report', [HomeController::class, 'save_practice_report']);
    Route::post('save_normal_report', [HomeController::class, 'save_normal_report']);
    Route::post('save_audio_report', [HomeController::class, 'save_audio_report']);
    Route::post('save_video_report', [HomeController::class, 'save_video_report']);
    Route::post('save_true_false_report', [HomeController::class, 'save_true_false_report']);
    Route::post('save_fear_factor_report', [HomeController::class, 'save_fear_factor_report']);
    Route::post('save_daily_quiz_report', [HomeController::class, 'save_daily_quiz_report']);
    Route::post('get_live_ultimate_challenge', [HomeController::class, 'get_live_ultimate_challenge']);
    Route::post('get_ultimate_challenge_question', [HomeController::class, 'get_ultimate_challenge_question']);
    Route::post('save_ultimate_challenge_report', [HomeController::class, 'save_ultimate_challenge_report']);
    Route::post('get_exam', [HomeController::class, 'get_exam']);
    Route::post('get_exam_question', [HomeController::class, 'get_exam_question']);
    Route::post('save_exam_report', [HomeController::class, 'save_exam_report']);
    Route::post('get_user_exam', [HomeController::class, 'get_user_exam']);
    Route::post('get_contest', [HomeController::class, 'get_contest']);
    Route::post('join_contest', [HomeController::class, 'join_contest']);
    Route::post('get_contest_question', [HomeController::class, 'get_contest_question']);
    Route::post('save_contest_question_report', [HomeController::class, 'save_contest_question_report']);
    Route::post('get_contest_leaderboard', [HomeController::class, 'get_contest_leaderboard']);
    Route::post('get_review_question_by_contest_id', [HomeController::class, 'get_review_question_by_contest_id']);
    Route::post('add_transaction', [HomeController::class, 'add_transaction']);
    Route::post('get_transaction', [HomeController::class, 'get_transaction']);
    Route::post('reward_setting', [HomeController::class, 'reward_setting']);
    Route::post('reward_transaction', [HomeController::class, 'reward_transaction']);
    Route::post('get_reward_transaction', [HomeController::class, 'get_reward_transaction']);
    Route::post('withdrawal_list', [HomeController::class, 'withdrawal_list']);
    Route::post('withdrawal_request', [HomeController::class, 'withdrawal_request']);
    Route::post('get_coin_leaderboard', [HomeController::class, 'get_coin_leaderboard']);
    Route::post('get_refer_earn_history', [HomeController::class, 'get_refer_earn_history']);
    Route::post('get_product', [HomeController::class, 'get_product']);
    Route::post('get_user_product', [HomeController::class, 'get_user_product']);
    Route::post('add_product_transaction', [HomeController::class, 'add_product_transaction']);

    // Route::post('create_one_vs_one_battle', [HomeController::class, 'create_one_vs_one_battle']);
    // Route::post('join_one_vs_one_battlek', [HomeController::class, 'create_one_vs_one_battle']);
    // Route::post('get_one_vs_one_battle_question', [HomeController::class, 'get_one_vs_one_battle_question']);
    // ---------------- OneToOneController ----------------
    // Route::post('create_one_to_one_challenge', 'Api\OneToOneController@create_one_to_one_challenge');
    // Route::post('join_one_to_one_challenge', 'Api\OneToOneController@join_one_to_one_challenge');
    // Route::post('get_question_by_one_to_one_challenge', 'Api\OneToOneController@get_question_by_one_to_one_challenge');
    // Route::post('save_one_to_one_challenge_report', 'Api\OneToOneController@save_one_to_one_challenge_report');
    // Route::post('get_one_to_one_challenge_leaderboard', 'Api\OneToOneController@get_one_to_one_challenge_leaderboard');
    // Route::post('get_one_to_one_challenge_by_user_id', 'Api\OneToOneController@get_one_to_one_challenge_by_user_id');
});
